#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Fork hexagon uv jy483752 540Mod01.fsh  by  jy483752   
//https://www.shadertoy.com/view/l32fWR
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define pi acos(-1.)
#define tau pi*2.

mat2 rot(float n){return mat2(vec2(cos(n),-sin(n)),vec2(sin(n),cos(n)));}

vec4 hexagon(vec2 p, float sca)
{
    p = p*sca;
    p.y /= sqrt(3.)/2.;
    float odd_rows = mod(floor(p.y),2.);
    p.x += odd_rows*.5;
    vec2 i_uv = floor(p),
         f_uv = fract(p)*2.-1.;
    
    vec2 q = (vec2(1)-abs(f_uv))*vec2(1.,sqrt(3.));
    
    if(q.x+q.y<.5){
        i_uv = i_uv+vec2(sign(f_uv.x)*.5-odd_rows+.5,sign(f_uv.y));
        f_uv = f_uv-2.*vec2(.5,1.)*sign(f_uv);
    }
    
    return vec4(i_uv, f_uv*vec2(1.,sqrt(3.)/2.));
}

vec2 rand(vec2 p)
{
    return fract(sin(
    p*vec2(4438.4183,6893.5365)+vec2(435.465,974.577)+
    p.yx*vec2(8538.4124,5793.5495)+vec2(845.421,447.257)
    ));
}

float ease(float n)
{
    return sin(n*pi-pi/2.)*.5+.5;
}

float truchet(vec2 p){
    float width = .2;
    
    vec2 q = vec2(p.x,abs(p.y));
    q.y-=2./sqrt(3.);
    float arc = step(width,abs(length(q)-1./sqrt(3.)));
    float line = step(width, abs(p.y));
    return arc*line;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord/iResolution.xy;
    uv -= .5;
    uv.x *= iResolution.x/iResolution.y;
    uv*=2.;
    
    uv*=rot(.2);
    uv.x-=iTime*.33;
    
    vec2 i_uv = hexagon(uv,2.0).xy;
    vec2 f_uv = hexagon(uv,2.0).zw;
    
    float i_t = floor(iTime*.75),
          f_t = fract(iTime*.75);
    float prev_r = rand(i_uv-i_t).x;
    float curr_r = rand(i_uv-i_t-1.).x;
    vec3 col = mix(vec3(1,.85,.78),vec3(.05,.1,.2),truchet(f_uv*rot(
    mix(floor(prev_r*3.), floor(curr_r*3.), ease(ease(f_t)))*tau/6.)
    ));
    
    fragColor = vec4(pow(col,vec3(.454545)),1.0);
///////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

